/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public final class IndianBringGiftMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianBringGiftMission.class.getName());
    public static final String TAG = "indianBringGiftMission";
    private static final String tag = "AI native gifter";
    private Colony colony;
    private boolean collected;
    private static final String COLLECTED_TAG = "collected";
    private static final String COLONY_TAG = "colony";

    public IndianBringGiftMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        this.collected = this.hasGift();
    }

    public IndianBringGiftMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    public Colony getColony() {
        return this.colony;
    }

    private boolean hasGift() {
        return this.getUnit().hasGoodsCargo();
    }

    private static String invalidUnitReason(AIUnit aiUnit) {
        IndianSettlement home;
        String reason = IndianBringGiftMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((home = aiUnit.getUnit().getHomeIndianSettlement()) == null || home.isDisposed() ? "home-destroyed" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = IndianBringGiftMission.invalidTargetReason(colony);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Player targetPlayer = colony.getOwner();
        switch (owner.getStance(targetPlayer)) {
            case UNCONTACTED: 
            case WAR: 
            case CEASE_FIRE: {
                return "bad-stance";
            }
            case PEACE: 
            case ALLIANCE: {
                Tension tension = unit.getHomeIndianSettlement().getAlarm(targetPlayer);
                if (tension == null || tension.getLevel().compareTo(Tension.Level.HAPPY) <= 0) break;
                return "unhappy";
            }
        }
        return null;
    }

    public static String invalidMissionReason(AIUnit aiUnit) {
        return IndianBringGiftMission.invalidUnitReason(aiUnit);
    }

    public static String invalidMissionReason(AIUnit aiUnit, Location loc) {
        String reason = IndianBringGiftMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? IndianBringGiftMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof IndianSettlement ? IndianBringGiftMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner()) : "target-invalid"));
    }

    @Override
    public Location getTransportDestination() {
        return null;
    }

    @Override
    public Location getTarget() {
        return this.collected ? this.colony : this.getUnit().getHomeIndianSettlement();
    }

    @Override
    public void setTarget(Location target) {
        if (target instanceof Colony) {
            this.colony = (Colony)target;
        }
    }

    @Override
    public Location findTarget() {
        return this.getTarget();
    }

    @Override
    public String invalidReason() {
        return IndianBringGiftMission.invalidMissionReason(this.getAIUnit(), this.colony);
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        Location blocker;
        Unit.MoveType mt;
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        IndianSettlement is = unit.getHomeIndianSettlement();
        block14: while (!this.collected) {
            mt = this.travelToTarget(this.getTarget(), null, lb);
            switch (mt) {
                case MOVE: {
                    break;
                }
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_MOVES: 
                case MOVE_ILLEGAL: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_REPAIR: {
                    return this.lbFail(lb, false, "aiUnit-died");
                }
                case MOVE_NO_TILE: {
                    return this;
                }
                case ATTACK_SETTLEMENT: 
                case ATTACK_UNIT: {
                    blocker = IndianBringGiftMission.resolveBlockage(aiUnit, this.getTarget());
                    if (blocker != null && AIMessage.askAttack(aiUnit, unit.getTile().getDirection(blocker.getTile()))) {
                        return this.lbAttack(lb, blocker);
                    }
                    this.moveRandomly(tag, null);
                    continue block14;
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            this.lbAt(lb);
            Goods gift = is.getRandomGift(this.getAIRandom());
            if (gift == null) {
                return this.lbFail(lb, false, "found no gift");
            }
            if (!AIMessage.askLoadGoods(is, gift.getType(), gift.getAmount(), aiUnit) || !this.hasGift()) {
                return this.lbFail(lb, false, "failed to collect gift");
            }
            this.collected = true;
            lb.add(", collected gift");
            return this.lbRetarget(lb);
        }
        block15: while (true) {
            mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
            switch (mt) {
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_MOVES: 
                case MOVE_ILLEGAL: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_REPAIR: {
                    return this.lbFail(lb, false, "aiUnit-died");
                }
                case MOVE_NO_TILE: {
                    return this;
                }
                case MOVE: 
                case ATTACK_SETTLEMENT: {
                    break block15;
                }
                case ATTACK_UNIT: {
                    blocker = IndianBringGiftMission.resolveBlockage(aiUnit, this.getTarget());
                    if (blocker != null && AIMessage.askAttack(aiUnit, unit.getTile().getDirection(blocker.getTile()))) {
                        return this.lbAttack(lb, blocker);
                    }
                    this.moveRandomly(tag, null);
                    continue block15;
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            break;
        }
        this.lbAt(lb);
        boolean result = AIMessage.askNativeGift(aiUnit, this.colony);
        return result ? this.lbDone(lb, false, "delivered") : this.lbFail(lb, false, "delivery");
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLLECTED_TAG, this.collected);
        if (this.colony != null) {
            xw.writeAttribute(COLONY_TAG, this.colony.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.collected = xr.getAttribute(COLLECTED_TAG, false);
        this.colony = xr.getAttribute(this.getGame(), COLONY_TAG, Colony.class, (Colony)null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

