/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class MoveToMessage
extends AttributeMessage {
    public static final String TAG = "moveTo";
    private static final String DESTINATION_TAG = "destination";
    private static final String UNIT_TAG = "unit";

    public MoveToMessage(Unit unit, Location destination) {
        super(TAG, UNIT_TAG, unit.getId(), DESTINATION_TAG, destination.getId());
    }

    public MoveToMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, DESTINATION_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        Game game = serverPlayer.getGame();
        String unitId = this.getStringAttribute(UNIT_TAG);
        String destinationId = this.getStringAttribute(DESTINATION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Location destination = game.findFreeColLocation(destinationId);
        if (destination == null) {
            return serverPlayer.clientError("Not a location: " + destinationId);
        }
        return this.igc(freeColServer).moveTo(serverPlayer, unit, destination);
    }
}

