/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class AddPlayerMessage
extends ObjectMessage {
    public static final String TAG = "addPlayer";
    private final Player destination;

    public AddPlayerMessage(Player destination, List<Player> players) {
        super(TAG);
        this.destination = destination;
        this.appendChildren(players);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddPlayerMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG);
        this.destination = null;
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        ArrayList<Player> players = new ArrayList<Player>();
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("player".equals(tag)) {
                    Player p = xr.readFreeColObject(game, Player.class);
                    if (p != null) {
                        players.add(p);
                    }
                } else {
                    this.expected("player", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChildren(players);
    }

    private List<Player> getPlayers() {
        return this.getChildren(Player.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.ADDPLAYER;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        FreeColXMLWriter.WriteScope ws = null;
        if (this.destination != null) {
            ws = xw.replaceScope(FreeColXMLWriter.WriteScope.toClient(this.destination));
        }
        super.toXML(xw);
        if (this.destination != null) {
            xw.replaceScope(ws);
        }
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        List<Player> players = this.getPlayers();
        if (freeColClient.isInGame()) {
            this.igc(freeColClient).addPlayerHandler(players);
        } else {
            this.pgc(freeColClient).addPlayerHandler(players);
        }
    }
}

