/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;

public class Resource
extends TileItem {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    public static final String TAG = "resource";
    private static final int UNLIMITED = -1;
    private ResourceType type;
    private int quantity;
    private static final String QUANTITY_TAG = "quantity";
    private static final String TILE_TAG = "tile";
    private static final String TYPE_TAG = "type";

    public Resource(Game game, Tile tile, ResourceType type, int quantity) {
        super(game, tile);
        if (type == null) {
            throw new RuntimeException("Type must not be null: " + this);
        }
        this.type = type;
        this.quantity = quantity;
    }

    public Resource(Game game, Tile tile, ResourceType type) {
        this(game, tile, type, type.getMaxValue());
    }

    public Resource(Game game, String id) {
        super(game, id);
    }

    public ResourceType getType() {
        return this.type;
    }

    public boolean isUnlimited() {
        return this.quantity == -1;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int newQuantity) {
        this.quantity = newQuantity;
    }

    public GoodsType getBestGoodsType() {
        return this.type.getBestGoodsType();
    }

    public int useQuantity(GoodsType goodsType, UnitType unitType, int potential) {
        return this.useQuantity(this.applyBonus(goodsType, unitType, potential) - potential);
    }

    private int useQuantity(int usedQuantity) {
        if (this.quantity != -1) {
            if (this.quantity >= usedQuantity) {
                this.quantity -= usedQuantity;
            } else {
                logger.severe("Insufficient quantity in " + this);
                this.quantity = 0;
            }
        }
        return this.quantity;
    }

    @Override
    public String getNameKey() {
        return this.getType().getNameKey();
    }

    @Override
    public final int getZIndex() {
        return 400;
    }

    @Override
    public boolean isTileTypeAllowed(TileType tileType) {
        return tileType.canHaveResourceType(this.getType());
    }

    @Override
    public int applyBonus(GoodsType goodsType, UnitType unitType, int potential) {
        int amount = -potential + (int)Resource.applyModifiers((float)potential, null, this.type.getModifiers(goodsType.getId(), unitType));
        return potential + (this.quantity == -1 || this.quantity > amount ? amount : this.quantity);
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return false;
        }
        return (int)Resource.applyModifiers(0.0f, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType)) > 0;
    }

    @Override
    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        return goodsType == null ? Stream.empty() : this.getType().getModifiers(goodsType.getId(), unitType);
    }

    @Override
    public boolean isNatural() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Map.Layer getLayer() {
        return Map.Layer.RESOURCES;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.type == null) {
            lb.add("\n  Resource without type: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Resource o = this.copyInCast(other, Resource.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.type = o.getType();
        this.quantity = o.getQuantity();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.getTile());
        xw.writeAttribute(TYPE_TAG, this.getType());
        xw.writeAttribute(QUANTITY_TAG, this.quantity);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(xr);
        this.tile = xr.findFreeColGameObject(this.getGame(), TILE_TAG, Tile.class, null, true);
        this.type = xr.getType(spec, TYPE_TAG, ResourceType.class, null);
        this.quantity = xr.getAttribute(QUANTITY_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        ResourceType ty = this.getType();
        String id = ty == null ? "NOTYPE" : ty.getId();
        return this.quantity == -1 ? id : Integer.toString(this.quantity) + " " + id;
    }
}

