/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.plaf.LAFUtilities;
import net.sf.freecol.common.resources.ResourceManager;

public class FreeColRadioButtonUI
extends BasicRadioButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new FreeColRadioButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LAFUtilities.setProperties(g, c);
        super.paint(g, c);
    }

    public static Icon createRadioButtonIcon() {
        return new RadioButtonIcon();
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        protected int getWidgetSize() {
            return FontLibrary.getMainFont().getSize() * 3 / 2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            ButtonModel model = ((AbstractButton)c).getModel();
            int widgetSize = this.getWidgetSize();
            if (!model.isEnabled()) {
                g.setColor(MetalLookAndFeel.getControlDisabled());
                g.fillRect(x, y, widgetSize - 1, widgetSize - 1);
            } else if (model.isPressed() && model.isArmed()) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(x, y, widgetSize - 1, widgetSize - 1);
            }
            if (c.hasFocus()) {
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawRect(x, y, widgetSize - 1, widgetSize - 1);
            }
            if (model.isSelected()) {
                BufferedImage radioButtonImage = ResourceManager.getImage("image.ui.button.radio.selected", new Dimension(this.getIconWidth(), this.getIconHeight()), false);
                Composite origComposite = g2d.getComposite();
                if (!model.isEnabled()) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                if (radioButtonImage != null) {
                    g2d.drawImage((Image)radioButtonImage, x, y, null);
                }
                g2d.setComposite(origComposite);
            } else {
                BufferedImage radioButtonImage = ResourceManager.getImage("image.ui.button.radio", new Dimension(this.getIconWidth(), this.getIconHeight()), false);
                if (radioButtonImage != null) {
                    g2d.drawImage((Image)radioButtonImage, x, y, null);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.getWidgetSize();
        }

        @Override
        public int getIconHeight() {
            return this.getWidgetSize();
        }
    }
}

