/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportReligiousPanel
extends ReportPanel {
    public ReportReligiousPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportReligionAction");
        Font font = FontLibrary.getScaledFont("normal-bold-smaller");
        Player player = this.getMyPlayer();
        Specification spec = this.getSpecification();
        this.reportPanel.setLayout(new MigLayout("wrap 6, fill", "center"));
        for (GoodsType gt : spec.getImmigrationGoodsTypeList()) {
            JLabel crosses = Utility.localizedLabel(gt);
            crosses.setFont(font);
            this.reportPanel.add((Component)crosses, "span, split 2");
            FreeColProgressBar progressBar = new FreeColProgressBar(freeColClient, gt, 0, player.getImmigrationRequired(), player.getImmigration(), player.getTotalImmigrationProduction());
            this.reportPanel.add((Component)progressBar, "span");
            for (Colony colony : player.getColonyList()) {
                WorkLocation wl = CollectionUtils.first(colony.getWorkLocationsForProducing(gt));
                if (!(wl instanceof Building)) continue;
                this.reportPanel.add((Component)this.createColonyButton(colony), "split 2, flowy");
                BuildingPanel bp = new BuildingPanel(this.getFreeColClient(), (Building)wl);
                bp.initialize();
                this.reportPanel.add(bp);
            }
        }
    }
}

