/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.PlayersTable;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;

public final class StartGamePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(StartGamePanel.class.getName());
    private boolean singlePlayerGame;
    private JCheckBox readyBox;
    private JTextField chat;
    private JTextArea chatArea;
    private JButton start;
    private JButton cancel;
    private JButton gameOptions;
    private JButton mapGeneratorOptions;
    private PlayersTable table;
    private final ActionListener startCmd = ae -> {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row > -1 && col > -1) {
            this.table.getCellEditor(row, col).stopCellEditing();
        }
        if (!this.checkVictoryConditions()) {
            return;
        }
        if (this.singlePlayerGame) {
            this.getMyPlayer().setReady(true);
        }
        this.getFreeColClient().getPreGameController().requestLaunch();
    };
    private final ActionListener cancelCmd = ae -> {
        GUI gui = this.getGUI();
        if (this.getFreeColClient().isLoggedIn()) {
            this.getFreeColClient().getConnectController().requestLogout(Game.LogoutReason.NEW_GAME);
        }
        this.getFreeColClient().stopServer();
        gui.removeComponent(this);
        gui.showNewPanel();
    };
    private final ActionListener readyBoxCmd = ae -> {
        this.getFreeColClient().getPreGameController().setReady(this.readyBox.isSelected());
        this.refreshPlayersTable();
    };
    private final ActionListener chatCmd = ae -> {
        if (!this.chat.getText().isEmpty()) {
            this.getFreeColClient().getPreGameController().sendChat(this.chat.getText());
            this.displayChat(this.getMyPlayer().getName(), this.chat.getText(), false);
            this.chat.setText("");
        }
    };
    private final ActionListener gameOptionsCmd = ae -> {
        FreeColClient fcc = this.getFreeColClient();
        this.getGUI().showGameOptionsDialog(fcc.isAdmin(), gameOptions -> {
            if (gameOptions != null) {
                fcc.getGame().setGameOptions((OptionGroup)gameOptions);
                fcc.getPreGameController().updateGameOptions();
            }
        });
    };
    private final ActionListener mapGeneratorOptionsCmd = ae -> {
        FreeColClient fcc = this.getFreeColClient();
        this.getGUI().showMapGeneratorOptionsDialog(fcc.isAdmin(), mgo -> {
            if (mgo != null) {
                fcc.getGame().setMapGeneratorOptions((OptionGroup)mgo);
                fcc.getPreGameController().updateMapGeneratorOptions();
            }
        });
    };

    public StartGamePanel(FreeColClient freeColClient) {
        super(freeColClient, null, new MigLayout("fill", "", "[grow][][]"));
    }

    public void initialize(boolean singlePlayer) {
        this.removeAll();
        this.singlePlayerGame = singlePlayer;
        if (singlePlayer || this.getMyPlayer().isAdmin()) {
            this.getSpecification().updateGameAndMapOptions();
        }
        NationOptions nationOptions = this.getGame().getNationOptions();
        this.cancel = Utility.localizedButton("cancel");
        JScrollPane chatScroll = null;
        this.table = new PlayersTable(this.getFreeColClient(), nationOptions, this.getMyPlayer());
        this.start = new FreeColButton(Messages.message("startGame")).withButtonStyle(FreeColButton.ButtonStyle.IMPORTANT);
        this.gameOptions = Utility.localizedButton(Messages.nameKey("gameOptions"));
        this.mapGeneratorOptions = Utility.localizedButton(Messages.nameKey("mapGeneratorOptions"));
        this.readyBox = new JCheckBox(Messages.message("startGamePanel.iAmReady"));
        if (this.singlePlayerGame) {
            this.getMyPlayer().setReady(false);
            this.readyBox.setSelected(true);
        } else {
            this.readyBox.setSelected(this.getMyPlayer().isReady());
            this.chat = new JTextField();
            this.chatArea = new JTextArea();
            chatScroll = new JScrollPane(this.chatArea, 22, 31);
        }
        this.refreshPlayersTable();
        JScrollPane tableScroll = new JScrollPane(this.table, 20, 31){

            @Override
            public Dimension getPreferredSize() {
                int tableWidth = StartGamePanel.this.getImageLibrary().scaleInt(600);
                int tableHeight = StartGamePanel.this.getImageLibrary().scaleInt(300);
                return new Dimension(tableWidth, tableHeight);
            }
        };
        tableScroll.getViewport().setOpaque(false);
        int tableWidth = this.getImageLibrary().scaleInt(600);
        int tableHeight = this.getImageLibrary().scaleInt(300);
        this.add((Component)tableScroll, "grow");
        tableScroll.setSize(this.getPreferredSize());
        if (!this.singlePlayerGame) {
            int chatHeight = (int)(FontLibrary.getFontScaling() * 100.0f);
            this.add((Component)chatScroll, "newline, height " + chatHeight + "px:,growx");
            this.add((Component)this.chat, "newline, growx");
        }
        this.add((Component)this.mapGeneratorOptions, "newline, split 2, growx, top, sg");
        this.add((Component)this.gameOptions, "growx, top, sg");
        this.add((Component)this.readyBox, "newline, span, split 3, tag left, gaptop unrelated");
        this.add((Component)this.start, "tag ok");
        this.add((Component)this.cancel, "tag cancel");
        if (!this.singlePlayerGame) {
            this.chat.addActionListener(this.chatCmd);
            this.chatArea.setEditable(false);
            this.chatArea.setLineWrap(true);
            this.chatArea.setWrapStyleWord(true);
            this.chatArea.setText("");
        }
        this.start.addActionListener(this.startCmd);
        this.cancel.addActionListener(this.cancelCmd);
        this.readyBox.addActionListener(this.readyBoxCmd);
        this.gameOptions.addActionListener(this.gameOptionsCmd);
        this.mapGeneratorOptions.addActionListener(this.mapGeneratorOptionsCmd);
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StartGamePanel.this.cancel.doClick();
            }
        });
        this.setEnabled(true);
    }

    private boolean checkVictoryConditions() {
        int n;
        Specification spec = this.getSpecification();
        if (this.singlePlayerGame && spec.getBoolean("model.option.victoryDefeatEuropeans") && !spec.getBoolean("model.option.victoryDefeatREF") && (n = CollectionUtils.count(this.getGame().getNationOptions().getNations().entrySet(), e -> ((Nation)e.getKey()).getType().isEuropean() && !((Nation)e.getKey()).isUnknownEnemy() && e.getValue() != NationOptions.NationState.NOT_AVAILABLE)) == 0) {
            this.getGUI().showInformationPanel("info.noEuropeans");
            return false;
        }
        return true;
    }

    public void displayChat(String senderName, String message, boolean privateChat) {
        if (privateChat) {
            this.chatArea.append(senderName + " (" + Messages.message("private") + "): " + message + "\n");
        } else {
            this.chatArea.append(senderName + ": " + message + "\n");
        }
    }

    public void refreshPlayersTable() {
        if (this.table != null) {
            this.table.update();
        }
    }

    @Override
    public void removeNotify() {
        this.start.removeActionListener(this.startCmd);
        this.cancel.removeActionListener(this.cancelCmd);
        this.readyBox.removeActionListener(this.readyBoxCmd);
        this.gameOptions.removeActionListener(this.gameOptionsCmd);
        this.mapGeneratorOptions.removeActionListener(this.mapGeneratorOptionsCmd);
        if (this.chat != null) {
            this.chat.removeActionListener(this.chatCmd);
        }
    }

    @Override
    public void requestFocus() {
        this.start.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        for (Component component : components = this.getComponents()) {
            component.setEnabled(enabled);
        }
        if (this.singlePlayerGame && enabled) {
            this.readyBox.setEnabled(false);
        }
        if (enabled) {
            this.start.setEnabled(this.getFreeColClient().isAdmin());
        }
        this.gameOptions.setEnabled(enabled);
    }
}

