/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.label.GoodsTypeLabel;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.GoodsType;

public class GoodsTypePanel
extends MigPanel
implements DropTarget {
    private boolean unique;

    public GoodsTypePanel(boolean unique) {
        this(new MigLayout(), unique);
    }

    public GoodsTypePanel(LayoutManager layout, boolean unique) {
        super(layout);
        this.unique = unique;
        this.setOpaque(false);
        this.setBorder(Utility.localizedBorder("cargoOnCarrier"));
    }

    public void setLabels(List<GoodsTypeLabel> labels) {
        this.removeAll();
        if (labels != null) {
            for (GoodsTypeLabel label : labels) {
                this.add(label);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private Component findLabel(GoodsType gt) {
        for (Component child : this.getComponents()) {
            if (!(child instanceof GoodsTypeLabel) || ((GoodsTypeLabel)child).getType() != gt) continue;
            return child;
        }
        return null;
    }

    public boolean addLabel(GoodsTypeLabel label) {
        if (!(label == null || this.unique && this.findLabel(label.getType()) != null)) {
            Component ret = super.add(label);
            this.revalidate();
            this.repaint();
            return ret != null;
        }
        return false;
    }

    public boolean removeGoodsType(GoodsType gt) {
        Component child = this.findLabel(gt);
        if (child != null) {
            super.remove(child);
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean accepts(GoodsType goodsType) {
        return true;
    }

    @Override
    public Component add(Component comp, boolean editState) {
        if (comp instanceof GoodsTypeLabel && this.addLabel((GoodsTypeLabel)comp)) {
            return comp;
        }
        return null;
    }
}

