/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import net.sf.freecol.common.resources.ImageCache;

public final class ColorizedImageCreator {
    private final ImageCache imageCache;

    public ColorizedImageCreator(ImageCache imageCache) {
        this.imageCache = imageCache;
    }

    public BufferedImage getColorizedImage(String key, float scalingFactor, Color color) {
        String compositeKey = "colorized##" + key + "##" + Integer.toHexString(color.getRGB());
        BufferedImage image = this.imageCache.getScaledImage(key, scalingFactor, false);
        return this.imageCache.getCachedImageOrGenerate(compositeKey, new Dimension(image.getWidth(), image.getHeight()), false, 0, () -> this.colorize(image, color));
    }

    private BufferedImage colorize(BufferedImage image, Color colorizeColor) {
        float[] hsbColorize = Color.RGBtoHSB(colorizeColor.getRed(), colorizeColor.getGreen(), colorizeColor.getBlue(), null);
        int width = image.getWidth();
        int height = image.getHeight();
        int[] image1Pixels = image.getRGB(0, 0, width, height, null, 0, width);
        float[] hsb = new float[3];
        for (int i = 0; i < image1Pixels.length; ++i) {
            int argb;
            int argba = image1Pixels[i];
            int a = (argba & 0xFF000000) >>> 24;
            int r = (argba & 0xFF0000) >>> 16;
            int g = (argba & 0xFF00) >>> 8;
            int b = argba & 0xFF;
            Color.RGBtoHSB(r, g, b, hsb);
            hsb[0] = hsbColorize[0];
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            image1Pixels[i] = argb = rgb & 0xFFFFFF | a << 24;
        }
        BufferedImage newImage = new BufferedImage(width, height, 2);
        newImage.setRGB(0, 0, width, height, image1Pixels, 0, width);
        return newImage;
    }
}

