/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public class ChangeAction
extends UnitAction {
    public static final String id = "changeAction";

    public ChangeAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    @Override
    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.getGUI().getActiveUnit().hasTile();
    }

    @Override
    public final void update() {
        super.update();
        Unit unit = this.getGUI().getActiveUnit();
        if (unit != null && unit.hasTile()) {
            if (unit.getColony() != null) {
                this.putValue("Name", Messages.getName("changeAction.enterColony"));
            } else if (unit.isOnCarrier()) {
                this.putValue("Name", Messages.getName("changeAction.selectCarrier"));
            } else {
                this.putValue("Name", Messages.getName("changeAction.nextUnitOnTile"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Unit unit = this.getGUI().getActiveUnit();
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.getGUI().showColonyPanel(tile.getColony(), unit);
        } else if (unit.isOnCarrier()) {
            this.getGUI().changeView(unit.getCarrier(), false);
        } else {
            boolean activeUnitFound = false;
            for (Unit u2 : tile.getUnitList()) {
                if (u2 == unit) {
                    activeUnitFound = true;
                    continue;
                }
                if (!activeUnitFound || u2.getState() != Unit.UnitState.ACTIVE || u2.getMovesLeft() <= 0) continue;
                this.getGUI().changeView(u2, false);
                return;
            }
            Unit active = CollectionUtils.find(tile.getUnits(), u -> u != unit && u.getState() == Unit.UnitState.ACTIVE && u.getMovesLeft() > 0);
            if (active != null) {
                this.getGUI().changeView(active, false);
            }
        }
    }
}

