/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.field;

import java.util.List;
import org.assertj.swing.dependency.fest_reflect.field.Invoker;
import org.assertj.swing.dependency.fest_reflect.reference.TypeRef;

public class FieldTypeRef<T> {
    private final String name;
    private final TypeRef<T> type;
    private final List<String> path;

    static <T> FieldTypeRef<T> newFieldTypeRef(String name, TypeRef<T> type, List<String> path) {
        if (type == null) {
            throw new NullPointerException("The type reference of the field to access should not be null");
        }
        return new FieldTypeRef<T>(name, type, path);
    }

    private FieldTypeRef(String name, TypeRef<T> type, List<String> path) {
        this.name = name;
        this.type = type;
        this.path = path;
    }

    public Invoker<T> in(Object target) {
        Object nestedTarget = null;
        for (String fieldName : this.path) {
            nestedTarget = Invoker.getNestedField(fieldName, nestedTarget == null ? target : nestedTarget);
        }
        return Invoker.newInvoker(this.name, this.type, nestedTarget == null ? target : nestedTarget);
    }
}

