/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public abstract class AbstractMutableTreeTableNode
implements MutableTreeTableNode {
    protected MutableTreeTableNode parent;
    protected final List<MutableTreeTableNode> children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public AbstractMutableTreeTableNode() {
        this(null);
    }

    public AbstractMutableTreeTableNode(Object userObject) {
        this(userObject, true);
    }

    public AbstractMutableTreeTableNode(Object userObject, boolean allowsChildren) {
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
        this.children = this.createChildrenList();
    }

    protected List<MutableTreeTableNode> createChildrenList() {
        return new ArrayList<MutableTreeTableNode>();
    }

    public void add(MutableTreeTableNode child) {
        this.insert(child, this.getChildCount());
    }

    @Override
    public void insert(MutableTreeTableNode child, int index) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("this node cannot accept children");
        }
        if (this.children.contains(child)) {
            this.children.remove(child);
            --index;
        }
        this.children.add(index, child);
        if (child.getParent() != this) {
            child.setParent(this);
        }
    }

    @Override
    public void remove(int index) {
        this.children.remove(index).setParent(null);
    }

    @Override
    public void remove(MutableTreeTableNode node) {
        this.children.remove(node);
        node.setParent(null);
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeTableNode newParent) {
        if (newParent == null || newParent.getAllowsChildren()) {
            if (this.parent != null && this.parent.getIndex(this) != -1) {
                this.parent.remove(this);
            }
        } else {
            throw new IllegalArgumentException("newParent does not allow children");
        }
        this.parent = newParent;
        if (this.parent != null && this.parent.getIndex(this) == -1) {
            this.parent.insert(this, this.parent.getChildCount());
        }
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    @Override
    public TreeTableNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public TreeTableNode getParent() {
        return this.parent;
    }

    @Override
    public Enumeration<? extends MutableTreeTableNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setAllowsChildren(boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        if (!this.allowsChildren) {
            this.children.clear();
        }
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isEditable(int column2) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int column2) {
    }

    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        return this.userObject.toString();
    }
}

