/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileReferenceUtil {
    public static PsiReference[] restrict(FileReferenceSet set, Condition<? super PsiFile> cond) {
        return FileReferenceUtil.restrict(set, cond, null);
    }

    public static PsiReference[] restrict(FileReferenceSet set, Condition<? super PsiFile> cond, Boolean soft) {
        Object[] references = set.getAllReferences();
        return (PsiReference[])ContainerUtil.map2Array((Object[])references, PsiReference.class, (Function)((NotNullFunction)fileReference -> new MyFileReference((FileReference)fileReference, cond, soft)));
    }

    public static Condition<PsiFile> byType(FileType instance) {
        return new TypeCondition(instance);
    }

    public static Condition<PsiFile> byNamespace(String ns) {
        return new PatternCondition((PsiFilePattern)XmlPatterns.xmlFile().withRootTag((ElementPattern)XmlPatterns.xmlTag().withNamespace((ElementPattern)XmlPatterns.string().equalTo((Object)ns))));
    }

    private static class TypeCondition
    implements Condition<PsiFile> {
        private final FileType myType;

        TypeCondition(FileType type) {
            this.myType = type;
        }

        public boolean value(PsiFile file) {
            return file.getFileType() == this.myType;
        }
    }

    private static class PatternCondition
    implements Condition<PsiFile> {
        private final PsiFilePattern myPattern;

        PatternCondition(PsiFilePattern pattern) {
            this.myPattern = pattern;
        }

        public boolean value(PsiFile o) {
            return this.myPattern.accepts((Object)o);
        }
    }

    private static class MyFileReference
    extends FileReference {
        private final Condition<? super PsiFile> myCond;
        private final Boolean mySoft;

        MyFileReference(FileReference fileReference, Condition<? super PsiFile> cond, @Nullable Boolean soft) {
            super(fileReference.getFileReferenceSet(), fileReference.getRangeInElement(), fileReference.getIndex(), fileReference.getCanonicalText());
            this.myCond = cond;
            this.mySoft = soft;
        }

        public boolean isSoft() {
            return this.mySoft == null ? super.isSoft() : this.mySoft.booleanValue();
        }

        public PsiFileSystemItem resolve() {
            PsiFileSystemItem result = super.resolve();
            if (result instanceof PsiFile && !this.myCond.value((Object)((PsiFile)result))) {
                return null;
            }
            return result;
        }

        public Object @NotNull [] getVariants() {
            Object[] variants = super.getVariants();
            Object[] objectArray = ContainerUtil.findAll((Object[])variants, o -> MyFileReference.match(o, this.myCond)).toArray();
            if (objectArray == null) {
                MyFileReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static boolean match(Object o, Condition<? super PsiFile> cond) {
            return !(o instanceof PsiFileSystemItem) || ((PsiFileSystemItem)o).isDirectory() || o instanceof PsiFile && cond.value((Object)((PsiFile)o));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/FileReferenceUtil$MyFileReference", "getVariants"));
        }
    }
}

