/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.FunctionWithJsFuncAnnotationInliner;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsCallTransformer;", "", "jsOrJsFuncCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateStatement", "generateExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getJsStatements", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCallTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCallTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsCallTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class JsCallTransformer {
    @NotNull
    private final IrCall jsOrJsFuncCall;
    @NotNull
    private final JsGenerationContext context;
    @NotNull
    private final List<JsStatement> statements;

    public JsCallTransformer(@NotNull IrCall jsOrJsFuncCall, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)jsOrJsFuncCall, (String)"jsOrJsFuncCall");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.jsOrJsFuncCall = jsOrJsFuncCall;
        this.context = context;
        this.statements = this.getJsStatements();
    }

    @NotNull
    public final JsStatement generateStatement() {
        JsStatement jsStatement;
        List list;
        if (this.statements.isEmpty()) {
            return JsEmpty.INSTANCE;
        }
        List $this$generateStatement_u24lambda_u240 = list = CollectionsKt.toMutableList((Collection)this.statements);
        boolean bl = false;
        Object object = CollectionsKt.last((List)$this$generateStatement_u24lambda_u240);
        SourceInfoAwareJsNode sourceInfoAwareJsNode = object instanceof JsReturn ? (JsReturn)object : null;
        if (sourceInfoAwareJsNode != null && (sourceInfoAwareJsNode = ((JsReturn)sourceInfoAwareJsNode).getExpression()) != null) {
            JsStatement jsStatement2;
            SourceInfoAwareJsNode expression2 = sourceInfoAwareJsNode;
            if (expression2 instanceof JsPrefixOperation && ((JsPrefixOperation)expression2).getOperator() == JsUnaryOperator.VOID) {
                jsStatement2 = (JsStatement)CollectionsKt.removeLastOrNull((List)$this$generateStatement_u24lambda_u240);
            } else {
                int n = CollectionsKt.getLastIndex((List)$this$generateStatement_u24lambda_u240);
                JsStatement jsStatement3 = ((JsExpression)expression2).makeStmt();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"makeStmt(...)");
                jsStatement2 = $this$generateStatement_u24lambda_u240.set(n, jsStatement3);
            }
        }
        List newStatements = list;
        switch (newStatements.size()) {
            case 0: {
                jsStatement = JsEmpty.INSTANCE;
                break;
            }
            case 1: {
                jsStatement = (JsStatement)JsAstUtilsKt.withSource$default((JsNode)CollectionsKt.single((List)newStatements), (IrElement)this.jsOrJsFuncCall, this.context, null, null, 12, null);
                break;
            }
            default: {
                jsStatement = new JsCompositeBlock(newStatements);
            }
        }
        return jsStatement;
    }

    @NotNull
    public final JsExpression generateExpression() {
        JsInvocation jsInvocation;
        JsExpression lastExpression;
        JsStatement jsStatement;
        Object object;
        Object object2;
        block8: {
            if (this.statements.isEmpty()) {
                return new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3));
            }
            object2 = this.statements;
            object = object2.listIterator(object2.size());
            while (object.hasPrevious()) {
                JsStatement jsStatement2;
                JsStatement it = jsStatement2 = object.previous();
                boolean bl = false;
                if (!(!(it instanceof JsSingleLineComment) && !(it instanceof JsMultiLineComment))) continue;
                jsStatement = jsStatement2;
                break block8;
            }
            jsStatement = null;
        }
        JsStatement lastStatement = jsStatement;
        object2 = lastStatement;
        JsExpression jsExpression = object2 instanceof JsReturn ? ((JsReturn)lastStatement).getExpression() : (lastExpression = object2 instanceof JsExpressionStatement ? ((JsExpressionStatement)lastStatement).getExpression() : null);
        if (this.statements.size() == 1 && lastExpression != null) {
            return (JsExpression)JsAstUtilsKt.withSource$default(lastExpression, (IrElement)this.jsOrJsFuncCall, this.context, null, null, 12, null);
        }
        List newStatements = CollectionsKt.toMutableList((Collection)this.statements);
        object = lastStatement;
        if (!(object instanceof JsReturn)) {
            if (object instanceof JsExpressionStatement) {
                newStatements.set(CollectionsKt.getLastIndex(this.statements), new JsReturn(((JsExpressionStatement)lastStatement).getExpression()));
            } else {
                ((Collection)newStatements).add(new JsReturn(new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3))));
            }
        }
        JsFunction syntheticFunction = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(newStatements), "");
        IrFunction currentFunction = this.context.getCurrentFunction();
        if (currentFunction != null && !currentFunction.isInline() && (currentFunction.getDispatchReceiverParameter() != null || currentFunction instanceof IrConstructor)) {
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsThisRef()};
            JsInvocation jsInvocation2 = new JsInvocation((JsExpression)new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)syntheticFunction), jsExpressionArray);
            jsInvocation = jsInvocation2;
        } else {
            jsInvocation = new JsInvocation((JsExpression)syntheticFunction, new JsExpression[0]);
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsInvocation, (IrElement)this.jsOrJsFuncCall, this.context, null, null, 12, null);
    }

    private final List<JsStatement> getJsStatements() {
        List<JsStatement> list;
        if (this.context.checkIfJsCode((IrFunctionSymbol)this.jsOrJsFuncCall.getSymbol())) {
            IrExpression irExpression = (IrExpression)this.jsOrJsFuncCall.getArguments().get(0);
            if (irExpression == null) {
                CompilationExceptionKt.compilationException((String)"JsCode is expected", (IrElement)((IrElement)this.jsOrJsFuncCall));
                throw new KotlinNothingValueException();
            }
            list = JsCodeKt.translateJsCodeIntoStatementList(irExpression, this.context.getCurrentFileEntry());
            if (list == null) {
                CompilationExceptionKt.compilationException((String)"Cannot compute js code", (IrElement)((IrElement)this.jsOrJsFuncCall));
                throw new KotlinNothingValueException();
            }
        } else if (this.context.checkIfHasAssociatedJsCode((IrFunctionSymbol)this.jsOrJsFuncCall.getSymbol())) {
            list = new FunctionWithJsFuncAnnotationInliner(this.jsOrJsFuncCall, this.context).generateResultStatement();
        } else {
            CompilationExceptionKt.compilationException((String)"`js` function call or function with @JsFunc annotation expected", (IrElement)((IrElement)this.jsOrJsFuncCall));
            throw new KotlinNothingValueException();
        }
        return list;
    }
}

