/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalToolwindowTabLeftRightAction;", "Lcom/intellij/openapi/wm/ToolWindowContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "moveLeft", "", "<init>", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "update", "isAvailable", "move", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terminal"})
public class MoveTerminalToolwindowTabLeftRightAction
extends ToolWindowContextMenuActionBase
implements DumbAware {
    private final boolean moveLeft;

    public MoveTerminalToolwindowTabLeftRightAction(boolean moveLeft) {
        this.moveLeft = moveLeft;
    }

    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project != null && content != null) {
            this.move(content, project);
        }
    }

    public void update(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        e.getPresentation().setVisible(e.getProject() != null && TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && content != null);
        e.getPresentation().setEnabled(e.getPresentation().isVisible() && this.isAvailable(content));
    }

    public final boolean isAvailable(@Nullable Content content) {
        Content content2 = content;
        if (content2 == null || (content2 = content2.getManager()) == null) {
            return false;
        }
        Content manager = content2;
        int ind = manager.getIndexOfContent(content);
        return this.moveLeft ? ind > 0 : ind >= 0 && ind < manager.getContentCount() - 1;
    }

    public final void move(@NotNull Content content, @NotNull Project project) {
        int otherInd;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ContentManager contentManager = content.getManager();
        if (contentManager == null) {
            return;
        }
        ContentManager manager = contentManager;
        int ind = manager.getIndexOfContent(content);
        int n = otherInd = this.moveLeft ? ind - 1 : ind + 1;
        if (ind >= 0 && otherInd >= 0 && otherInd < manager.getContentCount()) {
            Content content2 = manager.getContent(otherInd);
            Intrinsics.checkNotNull((Object)content2);
            Content otherContent = content2;
            TerminalTabCloseListener.Companion.executeContentOperationSilently(otherContent, (Function0<Unit>)((Function0)() -> MoveTerminalToolwindowTabLeftRightAction.move$lambda$0(manager, otherContent, ind)));
        }
    }

    private static final Unit move$lambda$0(ContentManager $manager, Content $otherContent, int $ind) {
        $manager.removeContent($otherContent, false, false, false).doWhenDone(() -> MoveTerminalToolwindowTabLeftRightAction.move$lambda$0$0($manager, $otherContent, $ind));
        return Unit.INSTANCE;
    }

    private static final void move$lambda$0$0(ContentManager $manager, Content $otherContent, int $ind) {
        $manager.addContent($otherContent, $ind);
    }
}

