/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateSslSocketFactory;
import com.intellij.execution.rmi.ssl.SslKeyStore;
import com.intellij.execution.rmi.ssl.SslUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DefaultSslSocketFactory
extends DelegateSslSocketFactory {
    public DefaultSslSocketFactory() throws GeneralSecurityException {
        this(false);
    }

    public DefaultSslSocketFactory(boolean trustEveryone) throws GeneralSecurityException {
        super(trustEveryone ? DefaultSslSocketFactory.createTrustEveryoneDelegate() : DefaultSslSocketFactory.createDefaultDelegate());
    }

    public DefaultSslSocketFactory(String trustEveryone) throws GeneralSecurityException {
        this(Boolean.parseBoolean(trustEveryone));
    }

    @NotNull
    private static SSLSocketFactory createDefaultDelegate() throws NoSuchAlgorithmException {
        SSLSocketFactory sSLSocketFactory = SSLContext.getDefault().getSocketFactory();
        if (sSLSocketFactory == null) {
            DefaultSslSocketFactory.$$$reportNull$$$0(0);
        }
        return sSLSocketFactory;
    }

    @NotNull
    private static SSLSocketFactory createTrustEveryoneDelegate() throws GeneralSecurityException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = SslKeyStore.getInstance();
        try {
            ks.load(null, null);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        kmf.init(ks, null);
        KeyManager[] km = kmf.getKeyManagers();
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(km, new TrustManager[]{new SslUtil.TrustEverybodyManager()}, null);
        SSLSocketFactory sSLSocketFactory = ctx.getSocketFactory();
        if (sSLSocketFactory == null) {
            DefaultSslSocketFactory.$$$reportNull$$$0(1);
        }
        return sSLSocketFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/rmi/ssl/DefaultSslSocketFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultDelegate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrustEveryoneDelegate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

